 /* '02 Game.cpp' */

 /* Plik standardowego nagwka Windows  */
#include <windows.h>
 /* Plik standardowego nagwka we/wy */
#include <stdio.h>

 /* Plik nagwka ConLib */
#include "ConLib.h"
 /* Plik nagowka CPlayer  */
#include "02 Player.h"

 /* Wyliczenie stanw gry */
enum GameStatus
{
 GameMainMenu     = 1,
 GameRunning      = 2,
 GamePaused       = 3,
 GameWon          = 4,
 GameLostLife     = 5,
 GameLost         = 6,
 GameExit         = 7,
 GameSplashScreen = 8
};

 /* Wyliczenie poziomw trudnoci */
enum GameDifficulty
{
 GameEasy         = 1,
 GameMedium       = 2,
 GameDifficult    = 3,
};

 /* Klasa bazowa gry */
class CGame
{
private:

  /* Informacje we/wy */
 ConLib *   m_Console;
 int        m_LastAction;

  /* Informacje o grze */
 int        m_GameStatus;
 COORD      m_Arena;
 CPlayer    m_Player;
 COORD *    m_Monsters;
 int        m_MonstersNumber;

public:

  /* Konstruktory / destruktory */
 CGame ();
 CGame (ConLib * Console);
 ~CGame ();

  /* Pokazuje odpowiedni informacje w zalenoci od stanu gry */
 void ShowSplash (void);
 void ShowMenu (void);
 void ShowGame (void);
 void ShowWon (void);
 void ShowLostLife (void);
 void ShowLost (void);
 void ShowExit (void);
 void Show (void);

  /* Przetwarza tur w zalenoci od stanu gry */
 void ProcessSplash (void);
 void ProcessMenu (void);
 void ProcessGame (void);
 void ProcessWon (void);
 void ProcessLostLife (void);
 void ProcessLost (void);
 void ProcessExit (void);
 void Process (void);

  /* Ustawia informacje konsoli */
 void SetConsole (ConLib * Console);

  /* Metody klasy Game */
 void StartNewGame (int Difficulty);
 void EndGame (void);
 void CheckCollisions ();
 int GetAction (void);
 int GetStatus (void);
 void MoveMonsters (void);
};